using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using BeWise.SharpBuilderTools.Ant;

namespace BeWise.SharpBuilderTools.Gui {

	public class FrmNAntRunner : System.Windows.Forms.Form
	{
		// *************************************************************************
		//                         Constructor / Destructor
		// *************************************************************************

		public FrmNAntRunner()
		{
			InitializeComponent();
		}

		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		// *************************************************************************
		//                             Private
		// *************************************************************************

		private System.Windows.Forms.GroupBox groupbox;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.ComboBox comboBox;
		private System.Windows.Forms.Button btOk;
		private System.Windows.Forms.Button btCancel;
		private System.ComponentModel.Container components = null;

		private BaseAnt fCurrentAnt;
		private BaseAntProject fProject;
		private string fSelectedTarget;

		private void InitializeComponent()
		{
			this.groupbox = new System.Windows.Forms.GroupBox();
			this.comboBox = new System.Windows.Forms.ComboBox();
			this.label1 = new System.Windows.Forms.Label();
			this.btOk = new System.Windows.Forms.Button();
			this.btCancel = new System.Windows.Forms.Button();
			this.groupbox.SuspendLayout();
			this.SuspendLayout();
			// 
			// groupbox
			// 
			this.groupbox.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
						| System.Windows.Forms.AnchorStyles.Left) 
						| System.Windows.Forms.AnchorStyles.Right)));
			this.groupbox.Controls.Add(this.comboBox);
			this.groupbox.Controls.Add(this.label1);
			this.groupbox.Location = new System.Drawing.Point(8, 8);
			this.groupbox.Name = "groupbox";
			this.groupbox.Size = new System.Drawing.Size(400, 112);
			this.groupbox.TabIndex = 0;
			this.groupbox.TabStop = false;
			this.groupbox.Text = "Targets";
			// 
			// comboBox
			// 
			this.comboBox.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
						| System.Windows.Forms.AnchorStyles.Right)));
			this.comboBox.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboBox.Location = new System.Drawing.Point(136, 32);
			this.comboBox.Name = "comboBox";
			this.comboBox.Size = new System.Drawing.Size(240, 21);
			this.comboBox.Sorted = true;
			this.comboBox.TabIndex = 1;
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(16, 35);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(104, 16);
			this.label1.TabIndex = 0;
			this.label1.Text = "Select your target:";
			// 
			// btOk
			// 
			this.btOk.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btOk.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btOk.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.btOk.Location = new System.Drawing.Point(248, 128);
			this.btOk.Name = "btOk";
			this.btOk.TabIndex = 1;
			this.btOk.Text = "Ok";
			// 
			// btCancel
			// 
			this.btCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btCancel.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.btCancel.Location = new System.Drawing.Point(328, 128);
			this.btCancel.Name = "btCancel";
			this.btCancel.TabIndex = 2;
			this.btCancel.Text = "Cancel";
			// 
			// FrmNAntRunner
			// 
			this.AcceptButton = this.btOk;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btCancel;
			this.ClientSize = new System.Drawing.Size(416, 158);
			this.Controls.Add(this.btCancel);
			this.Controls.Add(this.btOk);
			this.Controls.Add(this.groupbox);
			this.ForeColor = System.Drawing.Color.Black;
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "FrmNAntRunner";
			this.ShowInTaskbar = false;
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "NAnt Runner";
			this.groupbox.ResumeLayout(false);
			this.ResumeLayout(false);
		}

		// *************************************************************************
		//                         Protected
		// *************************************************************************

		protected void LoadProjectInList() {
			comboBox.Items.Clear();

			for (int i=0; i < Project.Targets.Length -1; i++){
				comboBox.Items.Add(Project.Targets[i].Name);
			}

			if (fSelectedTarget != null) {
				comboBox.SelectedIndex = comboBox.Items.IndexOf(fSelectedTarget);
			} else if (comboBox.Items.Count > 0) {
                comboBox.SelectedIndex = 0;
			}
		}

		// *************************************************************************
		//                            Public Properties
		// *************************************************************************

		public BaseAnt CurrentAnt {
			get {
				return fCurrentAnt;
			}

			set {
				fCurrentAnt = value;

				if (value != null) {
					this.Text = CurrentAnt.Name + " Runner";
				}
			}
		}

		public BaseAntProject Project {
			get {
				return fProject;
			}
			set {
				fProject = value;
				LoadProjectInList();
			}
		}

		public string SelectedTarget {
			get {
				return comboBox.Text;
			}
			set {
				fSelectedTarget = value;
			}
		}
	}
}
